<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Timviecbatdongsan247 - Kết nối thành công ứng viên và nhà tuyển dụng ngành bất động sản!",
  "alternateName": "Timviecbatdongsan247",
  "url": "https://timviecbatdongsan247.com/",
  "logo": "https://timviecbatdongsan247.com/wp-content/uploads/elementor/thumbs/vieclambatdongsan-qkk6n88dfbuejq14702a8cew5fgyrinqibenho6h48.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0828 874 383",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/timviecbatdongsan247",
    "https://www.youtube.com/channel/UCrNjfchxvt-Ain97muUeCoQ",
    "https://www.reddit.com/user/timviecbatdongsan247/",
    "https://www.linkedin.com/in/timviecbatdongsan247/",
    "https://timviecbatdongsan247.blogspot.com",
    "https://www.pinterest.com/timviecbatdongsan247/",
    "https://timviecbatdongsan247.tumblr.com/",
    "https://www.blogger.com/profile/07152177495039914560"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Timviecbatdongsan247 - Kết nối thành công ứng viên và nhà tuyển dụng ngành bất động sản!",
  "image": "https://timviecbatdongsan247.com/wp-content/uploads/elementor/thumbs/vieclambatdongsan-qkk6n88dfbuejq14702a8cew5fgyrinqibenho6h48.png",
  "@id": "https://timviecbatdongsan247.com/",
  "url": "https://timviecbatdongsan247.com/",
  "telephone": "0828 874 383",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "73 Nguyễn Thái Sơn, Phường 5, Gò Vấp, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.8284073,
    "longitude": 106.6917079
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/timviecbatdongsan247",
    "https://www.youtube.com/channel/UCrNjfchxvt-Ain97muUeCoQ",
    "https://www.reddit.com/user/timviecbatdongsan247/",
    "https://www.linkedin.com/in/timviecbatdongsan247/",
    "https://timviecbatdongsan247.blogspot.com",
    "https://www.pinterest.com/timviecbatdongsan247/",
    "https://timviecbatdongsan247.tumblr.com/",
    "https://www.blogger.com/profile/07152177495039914560"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Nguyễn Minh Thịnh",
  "url": "https://timviecbatdongsan247.com/author/admin/",
  "image": "https://anhvienpiano.com/wp-content/uploads/2019/10/chup-anh-chan-dung.jpg",
  "sameAs": [
    "https://sites.google.com/view/ceotimviecbatdongsan247/",
    "https://www.youtube.com/channel/UCHFniQbplgmtqNU4VBuHH0A",
    "https://www.reddit.com/user/ceominhthinh/",
    "https://twitter.com/ceo_minhthinh",
    "https://www.linkedin.com/in/ceonguyenminhthinh/",
    "https://ceominhthinh.blogspot.com",
    "https://www.pinterest.com/ceominhthinh/",
    "https://ceominhthinh.tumblr.com/"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "Tìm Việc Bất Động Sản 247"
  }  
}
</script>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-HGJBGCS9JE"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-HGJBGCS9JE');
</script>
	<meta name='dmca-site-verification' content='Y3NqVzFjRHFKRStQeXRmdmtHejlzMEV5dmdlaWFJUlBJcFZQd0pLSnNBcz01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">